<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\Helpers\Presets;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class Background extends BaseField
{

    private string $defaultColor;

    public function __construct(
        string $name,
        array $args = [],
    ) {
        parent::__construct($name, $args);
        $this->defaultColor = $args['defaultColor'] ?? 'rgba(255,255,255,1)';
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {

        $group = $builder
            ->addGroup($this->name);

        $group
            ->addFields([
                Presets::get('color', ColorSelect::class, [
                    $this->defaultColor
                ]),
                Presets::get('images', BackgroundImage::class),
            ]);

        return $group;
    }
}
