<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\PostTypes\Attachments;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class BackgroundImage extends BaseField
{

    public function fields(FieldsBuilder $builder): FieldBuilder
    {

        $group = $builder
            ->addRepeater($this->name)->setConfig('layout', 'block');

        $group
            ->addField('column_a', 'acfe_column', ['columns' => '6/12'])
            ->addImage('image')
            ->setConfig('return_format', 'data')
            ->addButtonGroup('type')
            ->addChoice('fill', 'Fill')
            ->addChoice('repeat', 'Repeat')
            ->addChoice('place', 'Place')
            ->addField('column_b', 'acfe_column', ['columns' => '6/12'])
            ->addButtonGroup('repeat')
            ->addChoice('repeat', '<i class="fa-sharp fa-light fa-arrows-up-down-left-right"></i>')
            ->addChoice('repeat-x', '<i class="fa-sharp fa-light fa-arrows-left-right"></i>')
            ->addChoice('repeat-y', '<i class="fa-sharp fa-light fa-arrows-up-down"></i>')
            ->setDefaultValue('repeat')
            ->conditional('type', '==', 'repeat')
            ->addField('position', 'position')
            ->conditional('type', '==', 'place')
            ->or('type', '==', 'repeat')
            ->and('repeat', '!=', 'repeat')
            ->addCheckbox('device')
            ->addChoice('mobile', '<i class="fa-sharp fa-light fa-mobile"></i>')
            ->addChoice('tablet', '<i class="fa-sharp fa-light fa-tablet"></i>')
            ->addChoice('desktop', '<i class="fa-sharp fa-light fa-desktop"></i>')
            ->setConfig('layout', 'horizontal')
            ->setDefaultValue(['desktop', 'tablet', 'mobile']);


        return $group;
    }
}
