<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\Helpers\Presets;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class ButtonAppearance extends BaseField
{
    static public function defaults() : array {
        return [
            'display' => 'outline',
            'contrast' => 'dark'
        ];
    }

    static public function cssClasses(array $appearance) : string {
        $display = 'button--display-' . $appearance['display'];
        $contrast = 'button--contrast-' . $appearance['contrast'];

        return implode(' ', [$display, $contrast]);
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {
        $group = $builder
            ->addGroup($this->name);

        $group
            ->addButtonGroup('display', [
                'choices' => [
                    'text' => 'Text',
                    'outline' => 'Outline Button',
                    'solid' => 'Solid Button',
                ],
                'default_value' => 'text',
            ])->setWidth(65)
            ->addButtonGroup('contrast', [
                'choices' => [
                    'light' => 'Light',
                    'dark' => 'Dark',
                ],
                'default_value' => 'light',
            ])->setWidth(35)
        ->endGroup();

        return $group;
    }
}
