<?php

namespace LeaseLeads\Theme\App\Fields;

use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class ColorSelect extends BaseField
{

    public static function getCssColor(string|array|null $color)
    {
        if ( empty($color) ) {
            return '';
        }

        if ( is_string($color) ) {
            return $color;
        }

        if ( empty($color['label']) && empty($color['color']) ) {
            return '';
        }

        if ( empty($color['label']) ) {
            return $color['color'];
        }

        if (! str_starts_with(strtolower($color['label']), 'color') ) {
            return $color['color'];
        }

        return 'var(--'.sanitize_title($color['label']).')';
    }

    public static function defaults(string $color = 'rgba(255, 255, 255, 1)') : array {
        return [
            'color' => $color
        ];
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {

        $palette = $builder
            ->addColorPicker($this->name)
            ->setConfig('ui', 1)
            ->setConfig('enable_opacity', 1)
            ->setConfig('return_format', 'color_label')
            ->setConfig('allow_null', 0)
            ->setConfig('display', 'palette')
            ->setConfig('color_picker', 1)
            ->setConfig('absolute', true)
            ->setConfig('theme_colors', 1)
            ->setConfig('input', true);

        return $palette;
    }
}
