<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\Helpers\Presets;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class ContentStack extends BaseField
{
    // Add new ones, but never change these values
    final const TEXT = 'text';

    final const IMAGE = 'image';

    final const MEDIA = 'media';

    final const BUTTONS = 'buttons';

    final const ICON_GRID = 'icon_grid';

    final const LIST = 'list';

    private array $include;

    public function __construct(
        string $name,
        array $args = []
    ) {
        parent::__construct($name, $args);
        $this->include = $args;
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {
        $layoutBuilder = $builder
            ->addFlexibleContent($this->name);

        $layouts = [];

        $method_map = [
            self::TEXT => 'text',
            self::IMAGE => 'image',
            self::MEDIA => 'media',
            self::BUTTONS => 'buttons',
            self::ICON_GRID => 'iconGrid',
            self::LIST => 'list',
        ];

        foreach ($this->include as $type) {
            if (array_key_exists($type, $method_map)) {
                $method = $method_map[$type];
                $layout = new FieldsBuilder($type);

                // Use the method name to create the layout to avoid duplication
                $layouts[$type] = $this->{$method}($layout);
            }

        }

        // back to indexed array
        $layoutBuilder
            ->addLayouts(array_values($layouts));

        return $layoutBuilder;
    }

    public function text(FieldsBuilder $layout): FieldsBuilder
    {
        $fields = [
            Presets::get('size', FontStyleSelect::class)
                ->setWidth(25),
            Presets::get('color', ColorSelect::class)
                ->setConfig('default_value', 'rgba(0,0,0,1)')
                ->setWidth(75),
        ];

        $layout
            ->addText('content')
            ->addFields($fields);

        return $layout;
    }

    public function image(FieldsBuilder $layout): FieldsBuilder
    {
        $layout
            ->addImage('image')
            ->setConfig('return_format', 'data');

        return $layout;
    }

    public function media(FieldsBuilder $layout): FieldsBuilder
    {
        $layout
            ->addFields([
                Presets::get('media', RichMedia::class)
            ]);

        return $layout;
    }

    public function buttons(FieldsBuilder $layout): FieldsBuilder
    {
        $buttons = Presets::get('buttons', Buttons::class);

        $layout
            ->addFields([$buttons]);

        return $layout;
    }

    public function iconGrid(FieldsBuilder $layout): FieldsBuilder
    {
        $layout
            ->addTab('Content', ['placement' => 'top'])
            ->addRepeater('icons')
            ->addText('icon')
                ->setInstructions('Use a font awesome icon code. Grab one <a href="https://fontawesome.com/icons" target="_blank">here</a>.')
                ->setWidth(100/3)
            ->addText('title')
                ->setWidth(100/3)
            ->endRepeater()
            ->addTab('Options', ['placement' => 'top'])
                ->addFields([
                    Presets::get('title_font_style', FontStyleSelect::class)->setWidth(50),
                    Presets::get('title_color', ColorSelect::class)->setWidth(50),
                    Presets::get('icon_color', ColorSelect::class)->setWidth(50),
                    Presets::get('accent_color', ColorSelect::class)->setWidth(50)
                ]);

        return $layout;
    }

    public function list(FieldsBuilder $layout) : FieldsBuilder
    {
        $layout
            ->addTab('Content', ['placement' => 'top'])
            ->addFields([Presets::get('heading', Text::class)])
            ->addRepeater('items')->setConfig('min', 1)
            ->addText('description')->setWidth(85)
            ->endRepeater()
            ->addTab('Options', ['placement' => 'top'])
            ->addFields([
                Presets::get('item_appearance', Text::class)->removeField('content'),
                Presets::get('background_color', ColorSelect::class),
            ]);

        $layout->modifyField('item_appearance', function($fields) {
            $fields->getField('item_appearance')->getField('size')->setDefaultValue('paragraph');

            return $fields;
        });

        return $layout;
    }
}
