<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\Data\Settings\FontStyles;
use LeaseLeads\Theme\App\Settings\LayoutSettings;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class FontStyleSelect extends BaseField
{

    static array $font_styles = [
        'display_h1' => 'Display H1',
        'display_h2' => 'Display H2',
        'display_h3' => 'Display H3',
        'h1' => 'H1',
        'h2' => 'H2',
        'h3' => 'H3',
        'h4' => 'H4',
        'h5' => 'H5',
        'h6' => 'H6',
        'paragraph' => 'Paragraph',
        'fine_print' => 'Fine Print',
    ];

    public function fields(FieldsBuilder $builder) : FieldBuilder {
        $dropdown = $builder
            ->addSelect($this->name);

        $dropdown
            ->setConfig('ui', 1)
            ->setDefaultValue('paragraph');

        $dropdown
            ->addChoices(static::$font_styles);

        return $dropdown;
    }
}
