<?php

namespace LeaseLeads\Theme\App\Fields;

use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class FormSelect extends BaseField
{

    public function fields(FieldsBuilder $builder): FieldBuilder
    {
        $select = $builder->addSelect($this->name);
        $select
            ->setConfig('ui', 1);

        if ( ! class_exists('\\GFFormsModel') ) {
            return $select;
        }

        $forms = \GFFormsModel::get_forms();

        foreach ($forms as $form) {
            $select->addChoice($form->id, $form->title);
        }

        return $select;
    }
}
