<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\Settings\LayoutSettings;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class LogoSelect extends BaseField
{

    static public function logoImage(?string $selection = '') : ?array {
        $property = get_field('property', 'options');

        $logos = [
            'white_logo' => $property['general']['white_logo'],
            'color_logo' => $property['general']['color_logo'],
            'black_logo' => $property['general']['black_logo'],
            'iconograph' => $property['general']['iconograph'],
        ];

        return $logos[$selection] ?? null;
    }

    static public function defaults($default = 'white_logo') : string {
        return $default;
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {
        $dropdown = $builder
            ->addSelect($this->name);

        $dropdown
            ->setConfig('ui', 1);

        $dropdown
            ->addChoices([
                'color_logo' => 'Color Logo',
                'white_logo' => 'White Logo',
                'black_logo' => 'Black Logo',
                'iconograph' => 'Brand Icon',
            ]);

        return $dropdown;
    }
}
