<?php

namespace LeaseLeads\Theme\App\Fields;

use StoutLogic\AcfBuilder\FieldsBuilder;

class MenuSelect extends BaseField
{

    public function fields(FieldsBuilder $builder): \StoutLogic\AcfBuilder\FieldBuilder
    {
        $menus = wp_get_nav_menus();

        $dropdown = $builder
            ->addSelect($this->name)
            ->setConfig('ui', 1);

        foreach ($menus as $menu) {
            $dropdown
                ->addChoice($menu->term_id, $menu->name);
        }

        return $dropdown;
    }
}
