<?php

namespace LeaseLeads\Theme\App\Fields;

use LeaseLeads\Theme\App\Helpers\Presets;
use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class Pagination extends BaseField {

    public static function defaults(): array
    {
        return [
            'icons' => ColorSelect::defaults('#000000'),
            'background' => ColorSelect::defaults('rgba(255,255,255,0.7)')
        ];
    }

    public static function cssVars(array $data): string {
        return implode("\n\t\t", [
            '--pagination-background-color:' . ColorSelect::getCssColor($data['background']) . ';',
            '--pagination-icon-color: ' . ColorSelect::getCssColor($data['icons']) . ';'
        ]);
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {
        $group = $builder
            ->addGroup($this->name);

        $group
            ->addFields([
                Presets::get('icons', ColorSelect::class),
                Presets::get('background', ColorSelect::class)
            ])
            ->endGroup();

        return $group;
    }
}
