<?php

namespace LeaseLeads\Theme\App\Fields;

use StoutLogic\AcfBuilder\FieldBuilder;
use StoutLogic\AcfBuilder\FieldsBuilder;

class Spacing extends BaseField {
    private FieldsBuilder $builder;

    private int $column = 0;

    public function __construct(string $name, array $args = [])
    {
        $this->name = $name;
    }

    public static function spacingClasses($data) {
        if ( ! $data ) {
            return '';
        }

        $classes = ['has-spacing'];

        if($data['padding_top']) {
            $classes[] = 'padding-top-' . $data['padding_top_size'];
        } else {
            $classes[] = 'padding-top-none';
        }

        if($data['margin_top']) {
            $classes[] = 'margin-top-' . $data['margin_top_size'];
        } else {
            $classes[] = 'margin-top-none';
        }

        if($data['padding_bottom']) {
            $classes[] = 'padding-bottom-' . $data['padding_bottom_size'];
        } else {
            $classes[] = 'padding-bottom-none';
        }

        if($data['margin_bottom']) {
            $classes[] = 'margin-bottom-' . $data['margin_bottom_size'];
        } else {
            $classes[] = 'margin-bottom-none';
        }

        return implode(' ', $classes);
    }

    public static function defaults() : array {
        return [
            'padding_top' => true,
            'padding_top_size' => 'default',
            'margin_top' => true,
            'margin_top_size' => 'default',
            'padding_bottom' => true,
            'padding_bottom_size' => 'default',
            'margin_bottom' => true,
            'margin_bottom_size' => 'default',
        ];
    }

    private function makeSpacer(string $name, $group) {
        $column_a = 'column_' . chr(97 + $this->column);
        $this->column++;

        $column_b = 'column_' . chr(97 + $this->column);
        $this->column++;

        $group
            ->addField($column_a, 'acfe_column', ['columns' => '3/12'])
            ->addTrueFalse($name)
            ->setDefaultValue(1)
            ->setConfig('ui', 1)
            ->addField($column_b, 'acfe_column', ['columns' => '3/12'])
            ->addSelect($name . '_size')
            ->setDefaultValue('default')
            ->setChoices([
                'default' => 'Default',
                'sm' => 'Small',
                'md' => 'Medium',
                'lg' => 'Large',
            ])
            ->conditional($name, '==', 1);
    }

    public function fields(FieldsBuilder $builder): FieldBuilder
    {

        $group = $builder
            ->addGroup($this->name);

        $this->makeSpacer('padding_top', $group);
        $this->makeSpacer('margin_top', $group);
        $this->makeSpacer('padding_bottom', $group);
        $this->makeSpacer('margin_bottom', $group);

        $group
            ->endGroup();

        return $group;
    }
}
