<?php

use LeaseLeads\Theme\App\Fields\Background;
use LeaseLeads\Theme\App\Fields\ButtonAppearance;
use LeaseLeads\Theme\App\Fields\ColorSelect;
use LeaseLeads\Theme\App\Fields\Text;
use LeaseLeads\Theme\App\Helpers\Settings;
use LeaseLeads\Theme\App\Helpers\View;

[
  'options' => $data
] = $args;

$data = Settings::parseArgs($data, [
  'heading' => Text::defaults(),
  'message' => Text::defaults(),
  'auto_dismiss' => false,
  'agree_button' => ButtonAppearance::defaults(),
  'background' => Background::defaults(),
  'position' => 'bottom left',
  'border' => ColorSelect::defaults($data['background']['color']['color'] ?? 'rgba(0,0,0,0)'),
  'close_button' => ColorSelect::defaults('#ffffff'),
  'privacy_policy_url' => get_privacy_policy_url()
]);

$data['position'] = implode(' ', array_reverse(explode(' ', $data['position'])));

?>

<div
  class="
    ccb
    position-x--<?= explode(' ', $data['position'])[0]; ?>
    position-y--<?= explode(' ', $data['position'])[1]; ?>
    <?= Background::backgroundClasses($data['background']); ?>"
  data-ccb='<?= htmlspecialchars(json_encode([
    'agree' => '[href*="#ccb-agree"]',
    'close' => '.ccb__close',
    'privacy_policy_url' => $data['privacy_policy_url'],
    'auto_dismiss' => $data['auto_dismiss'],
  ])); ?>'
  style="
    <?= Background::backgroundVars($data['background']); ?>
    --border-color: <?= ColorSelect::getCssColor($data['border']); ?>;
    --close-button: <?= ColorSelect::getCssColor($data['close_button']); ?>;
  ">

<!--  <div class="ccb__close"><i class="fa-sharp fa-times fa-light"></i></div>-->

  <div class="ccb__content content-stack">

    <?php View::component('text', $data['heading']); ?>

    <?php View::component('text', $data['message']); ?>

    <?php if ( ! $data['auto_dismiss'] ) { ?>
      <?php View::component('button', array_merge($data['agree_button'], [
        'url' => '#ccb-agree'
      ])); ?>
    <?php } ?>

  </div>


</div>
