<?php

namespace LeaseLeads\ThemeCookieCompiance\Providers;


use LeaseLeads\ThemeCookieCompiance\Data\CookieCompliance as CookieComplianceData;
use LeaseLeads\ThemeCookieCompiance\Settings\CookieCompliance;
use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Core\Services\View;
use LeaseLeads\ThemeKit\Data\Services\FieldableDataAdapter;

class CookieComplianceProvider extends AbstractProvider implements ProviderInterface
{
    public function boot() : void
    {
        add_action('wp_footer', [$this, 'doCookieCompliance']);
    }

    public function doCookieCompliance() : void
    {
        $settings = new CookieCompliance();
        $values = $settings->values();

        if ( empty($values['enable_cookie_compliance']) ) {
            return;
        }

        $cookie_compliance = $values['cookie_compliance'];
        $adapter = new FieldableDataAdapter($cookie_compliance, CookieComplianceData::class);

        View::layout('cookie-compliance', $adapter->getData(), true);
    }
}
