<?php

namespace LeaseLeads\ThemeCookieCompiance\Settings;

use LeaseLeads\ThemeKit\Fields\Presets\Background;
use LeaseLeads\ThemeKit\Fields\Presets\ButtonAppearance;
use LeaseLeads\ThemeKit\Fields\Presets\ColorSelect;
use LeaseLeads\ThemeKit\Fields\Presets\Text;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use LeaseLeads\ThemeKit\Settings\Sections\AbstractSection;
use StoutLogic\AcfBuilder\Builder;

class CookieCompliance extends AbstractSection implements SectionInterface {

    public function page(): string
    {
        return 'layout-settings';
    }

    public function title(): string
    {
        return 'Cookie Compliance';
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addTrueFalse('enable_cookie_compliance')->setConfig('ui', 1)
            ->addTab('Content', ['placement' => 'top'])
            ->addText('privacy_policy_url')
            ->setInstructions('Anywhere <code>#privacy-policy</code> is used as the URL for a link, button, menu item, or anything else, it will be replaced with the url provided here.')
            ->setDefaultValue('https://leaseleads.co/privacy-policy')
            ->addTrueFalse('auto_dismiss')
            ->setInstructions('Cookie compliance banner will automatically dismiss after the first interaction on the site. No need to click the button.')
            ->setConfig('ui', 1)
            ->setDefaultValue(0)
            ->addFields([
                Presets::get('heading', Text::class),
                Presets::get('message', Text::class),
                Presets::get('agree_button', ButtonAppearance::class)
            ])
            ->addTab('Options', ['placement' => 'top'])
            ->addField('column_a', 'acfe_column', ['columns' => '6/12'])
            ->addFields([
                Presets::get('background', Background::class),
            ])
            ->addField('column_b', 'acfe_column', ['columns' => '6/12'])
            ->addField('position', 'position', ['label' => 'Screen Position'])
            ->setDefaultValue('bottom left')
            ->addFields([ Presets::get('border', ColorSelect::class)->setDefaultValue('rgba(0, 0, 0, 0)') ]);

        $builder
            ->modifyField('heading->content', function($group) {
                $group->getField('content')
                    ->setConfig('default_value', 'We value your privacy');

                return $group;
            });

        $builder
            ->modifyField('message->content', function($group) {
                $group->getField('content')
                    ->setConfig('default_value', 'This site uses cookies to allow for essential site function and marketing data. By using this website you agree to our <a href="#privacy-policy">privacy policy</a>.');

                return $group;
            });

        $builder
            ->modifyField('agree_button', function($group) {
                $group
                    ->getField('agree_button')
                    ->conditional('auto_dismiss', '==', '0')
                    ->addField('title', 'text')
                    ->setLabel('Text')
                    ->setConfig('default_value', 'Agree & Continue');

                return $group;
            });
    }
}
