<?php

namespace LeaseLeads\ThemeLogin\Settings;

use LeaseLeads\ThemeKit\Fields\Presets\Background;
use LeaseLeads\ThemeKit\Fields\Presets\ColorSelect;
use LeaseLeads\ThemeKit\Fields\Presets\LogoSelect;
use LeaseLeads\ThemeKit\Fields\Services\Presets;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use LeaseLeads\ThemeKit\Settings\Sections\AbstractSection;
use StoutLogic\AcfBuilder\Builder;

class Login extends AbstractSection implements SectionInterface {

    public function page(): string
    {
        return 'layout-settings';
    }

    public function fields(Builder $builder): void
    {
        $builder
            ->addFields([
                Presets::get('logo', LogoSelect::class)->setDefaultValue('iconograph')
                    ->setConfig('default_value', 'white_logo'),
                Presets::get('text_color', ColorSelect::class)
                    ->setConfig('default_value', 'rgba(0,0,0,1)'),
                Presets::get('accent_color', ColorSelect::class)
                    ->setConfig('default_value', 'rgba(0,0,0,0)'),
                Presets::get('background', Background::class)
            ]);
    }

    public function title(): string
    {
        return 'Login';
    }
}
