<?php

namespace LeaseLeads\ThemeKit\Acf\Extensions;

use Androlax2\AcfImageMap\ImageMapField;
use LeaseLeads\ThemeKit\Acf\Contracts\ExtensionInterface;

class AcfImageMap implements ExtensionInterface {

    public function load(): void
    {
        add_filter('acf/include_field_types', [$this, 'instance']);
        add_filter('acf/register_fields', [$this, 'instance']);
        add_action('admin_head', [$this, 'adminStyles']);
    }

    public function instance(): ImageMapField
    {
        $url = get_template_directory_uri().'/vendor/wpackagist-plugin/acf-image-map/dist';
        return new ImageMapField($url);
    }

    public function adminStyles(): void
    {
        echo '
        <style>
            .acfImageMapPoint {max-width: none;}
            .acfImageMapPoint > img {user-select: none;}
            .acfImageMapPoint__input { display: none !important; }
        </style>';
    }
}
