<?php

namespace LeaseLeads\ThemeKit\Acf\Services;

use LeaseLeads\ThemeKit\Acf\Contracts\Extension;
use LeaseLeads\ThemeKit\Acf\Contracts\ExtensionInterface;

class ExtensionLoader {

    protected array $extensions = [];

    public function registerExtension(ExtensionInterface $extension): void
    {
        $this->extensions[] = $extension;
    }

    public function loadExtensions(): void
    {
        collect($this->extensions)
            ->each(function (ExtensionInterface $extension) {
                $extension->load();
            });
    }


}
