<?php

namespace LeaseLeads\ThemeKit\Core\Services\Vite;

class Manifest {

    protected string $buildFolder;

    protected string $manifestPath;

    protected array $manifest;


    public function __construct($buildFolder = 'public') {
        $this->buildFolder = $buildFolder;
        $this->manifestPath = implode('/', [get_template_directory(), $this->buildFolder, 'manifest.json']);
        $this->manifest = json_decode(file_get_contents($this->manifestPath), true);
    }

    public function root() {
        return $this->buildFolder;
    }

    public function manifest(): array
    {
        return $this->manifest;
    }

    public function record($resource): ?array {
        return $this->manifest()[$resource] ?? null;
    }

    public function file(string $resource): string {
        return $this->manifest()[$resource]['file'];
    }

    public function dependants(string $resource, string $type = 'css'): ?array {
        return $this->manifest()[$resource][$type] ?? null;
    }

}
