<?php

namespace LeaseLeads\ThemeKit\Core\Services\Vite;

class Vite {

    protected Server $server;

    protected Manifest $manifest;

    protected Asset $asset;

    protected Adapter $adapter;

    static string $viteHandle = 'leaseleads-theme-vite-client';
    static string $viteEndpoint = '';


    public function __construct(string $buildFolder = 'public') {
        $this->server = new Server($buildFolder);
        $this->manifest = new Manifest($buildFolder);
        $this->adapter = new Adapter($this->manifest);
        $this->asset = new Asset($this->server, $this->manifest, $this->adapter);
    }

    public function enqueue(string $resource, ?string $handle = null): string
    {
        return $this->asset->enqueue($resource, $handle);
    }

    public function record(string $resource): ?array
    {
        return $this->manifest->record($resource);
    }

    public function endpoint($record): string
    {
        return $this->server->endpoint($record);
    }

    public function hot(): bool
    {
        return $this->server->hot();
    }

}
