<?php

namespace LeaseLeads\ThemeKit\Core\Services;

use Dotenv\Dotenv;
use Illuminate\Support\Arr;

class Environment
{
    private static ?array $env = null;

    public function __construct()
    {
        static::$env = static::$env ?? Dotenv::createImmutable(get_template_directory())
            ->safeLoad();
    }

    public function isProduction(): bool
    {
        return self::getEnvironment() === 'production';
    }

    public function isStaging(): bool
    {
        return self::getEnvironment() === 'staging';
    }

    public function isLocal(): bool
    {
        $env = self::getEnvironment();
        return $env === 'local' || $env === 'development' || $env === 'dev';
    }

    public function getEnvironment(): string
    {
        if (defined('WP_ENV')) {
            return WP_ENV;
        }

        if (defined('WP_DEBUG')) {
            return WP_DEBUG ? 'local' : 'production';
        }

        return 'production';
    }

    public function get($key)
    {
        return Arr::get(static::$env, $key, null);
    }
}
