<?php

namespace LeaseLeads\ThemeKit\Core\Services;

use LeaseLeads\ThemeKit\Core\Contracts\CommandInterface;

class ThemeCommand
{

    private $commands = [];

    public function registerCommand(CommandInterface $command): void
    {
        $command = new $command();

        $this->commands[$command->name()] = $command;
    }


    public function name(): string
    {
        return 'll';
    }

    public function description(): string
    {
        return 'Theme commands.';
    }

    public function printCommandHelp($command) {
        $name = $command->name();
        $arguments = $command->arguments();
        $description = $command->description();
        \WP_CLI::line(sprintf('%s: %s', $name, $description));

        if ( empty($arguments) ) {
            return;
        }

        \WP_CLI::line('Arguments:');

        foreach ($arguments as $arg_name => $arg_details) {
            $optional = $arg_details['optional'] ? ' (optional)' : '';
            $default = isset($arg_details['default']) ? ' [default: ' . $arg_details['default'] . ']' : '';
            \WP_CLI::line(sprintf('  --%s: %s%s%s', $arg_name, $arg_details['description'], $optional, $default));
        }
    }

    public function run($args = [], $flags = []): void
    {
        if (count($args) < 2) {
            $args[] = 'help'; // Default to help if no subcommand is provided
        }

        array_shift($args); // Remove 'll' from the arguments
        $command = array_shift($args); // Get the first argument as the subcommand

        if ( $command === 'help' ) {
            foreach($this->commands as $name => $command) {
                $this->printCommandHelp($command);
                \WP_CLI::line(''); // Add a newline for better readability
            }
            return;
        }

        if ( ! isset($this->commands[$command]) ) {
            \WP_CLI::line("Unknown subcommand: $command");
            return;
        }

        if ( array_key_exists('help', $flags) ) {
            $this->printCommandHelp($command);
            return;
        }

        $this->commands[$command]->run($flags);
    }
}
