<?php

namespace LeaseLeads\ThemeKit\Deploy\Providers;


use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Core\Services\Filter;
use LeaseLeads\ThemeKit\Deploy\Commands\Publish;
use LeaseLeads\ThemeKit\Deploy\Commands\Pull;
use LeaseLeads\ThemeKit\Deploy\Commands\Push;
use LeaseLeads\ThemeKit\Deploy\Commands\Zip;

class Deploy extends AbstractProvider implements ProviderInterface {

    public function register() : void {

        Filter::register('config/app/commands', function($commands) {
            $commands[] = Zip::class;
            $commands[] = Pull::class;
            $commands[] = Push::class;
            $commands[] = Publish::class;

            return $commands;
        });

    }


}
