<?php

return [


    /**
     * The server where the theme is hosted for preview and staging.
     */
    'staging' => [
        'url' => env('STAGING_SITE_URL', 'root'),
        'path' => env('STAGING_SITE_PATH', '/var/www/html'),
        'user' => env('STAGING_SSH_USER', 'root'),
    ],

    /**
     * The server where updates are stored and deployed to sites from.
     */
    'update' => [
        'host' => env('UPDATE_HOST'),
        'user' => env('UPDATE_USER', 'updates'),
        'path' => env('UPDATE_PATH', '/home/templates/webapps/templates/updates/'),
    ],

    /**
     * Files and directories to be ignored when zipping the theme.
     * These files will not be included in the zip file created for deployment.
     */
    'zip_exclusions' => [
        ".env",
        ".git/*",
        ".idea/*",
        ".vscode/*",
        ".DS_Store",
        ".gitignore",
        "**/.DS_Store",
        ".editorconfig",
        "package.json",
        "vite.config.js",
        "composer.json",
        "node_modules*",
        "pnpm-lock.yaml",
        "resources/login/*",
        "resources/admin/*",
        "resources/public/styles/*",
        "resources/public/scripts/*",
        "resources/public/public.js",
    ],

    /**
     * Files and directories to be ignored when pushing to staging.
     */
    'push_exclusions' => [
        'node_modules/',
        'tmp/*',
        '.git/',
    ]
];
