<?php

namespace LeaseLeads\ThemeKit\Plugins\Services;


use LeaseLeads\ThemeKit\Core\Services\Filter;
use LeaseLeads\ThemeKit\Plugins\Contracts\InstallerInterface;
use WP_Dependency_Installer;

class WpDependencyInstaller implements InstallerInterface {

    protected array $configuration;
    protected WP_Dependency_Installer $installer;

    protected static $run;

    public function __construct(array $configuration) {
        $this->configuration = $configuration;
        $this->configuration['required'] = true;
        $this->installer = WP_Dependency_Installer::instance(get_template_directory());
    }

    public function configuration() : array {
        $slug = basename($this->configuration['slug'], '.php');
        return Filter::apply("plugins/$slug/configuration", $this->configuration);
    }

    public function install(): void
    {
        $this->installer->register([$this->configuration()]);
    }

    public function activate(): void
    {
        if ( self::$run ) {
            return;
        }

        // Ensure that the activation only runs once
        self::$run = true;
        $this->installer->run();
    }

    public function isInstalled() : bool
    {
        return $this->installer->is_installed($this->configuration()['slug']);
    }

    public function isActivated() : bool
    {
        return $this->installer->is_active($this->configuration()['slug']);
    }
}
