<?php

namespace LeaseLeads\ThemeKit\Shortcodes\Providers;

use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Shortcodes\Contracts\ShortcodeInterface;
use function LeaseLeads\ThemeKit\bound_by;
use function LeaseLeads\ThemeKit\config;

class Shortcodes extends AbstractProvider implements ProviderInterface {

    public function register(): void
    {
        add_action('init', function() {
            $this->registerShortcodes();
        });
    }

    protected function registerShortcodes(): void
    {
        $shortcodes = config('shortcodes', []);

        foreach ($shortcodes as $shortcode) {
            $shortcode = new $shortcode();

            if ( ! bound_by($shortcode, ShortcodeInterface::class) ) {
                continue;
            }

            $instance = new $shortcode();

            add_shortcode($instance->tag(), function($attributes, $content = null) use ($instance) {
                $attributes = $instance->attributes($attributes);
                return $instance->render($attributes, $content);
            });
        }
    }


}
