<?php

namespace LeaseLeads\ThemeKit\Acf\Extensions;

use LeaseLeads\ThemeKit\Acf\Contracts\Extension;
use LeaseLeads\ThemeKit\Core\Services\Filter;
use StoutLogic\AcfBuilder\FieldsBuilder;

class AdvancedLinks implements Extension {

    public function load(): void
    {
        add_filter('acfe/fields/advanced_link/sub_fields', [$this, 'advancedLinkSubFields'], 10, 1);
    }

    public function advancedLinkSubFields($fields) {
        $group = $this->advancedLinkFields()->build();

        $new_fields = $group['fields'];

        foreach ($new_fields as $key => $field) {
            $new_fields[$key]['key'] = str_replace('field_advanced_link_', '', $field['key']);
        }

        return array_merge([], $fields, $new_fields);
    }

    protected function advancedLinkFields() : FieldsBuilder
    {
        $builder = new FieldsBuilder('advanced_link');
        $builder
            ->addButtonGroup('display')
            ->addChoice('text', 'Text')
            ->addChoice('outline', 'Outline Button')
            ->addChoice('solid', 'Solid Button')
            ->setDefaultValue('text')
            ->addButtonGroup('contrast')
            ->addChoice('light', 'Light')
            ->addChoice('dark', 'Dark')
            ->addChoice('accent', 'Accent')
            ->setDefaultValue('light')
            ->addTrueFalse('show_brand_icon')
            ->setConfig('ui', 1)
            ->addTrueFalse('show_arrow_icon')
            ->setConfig('ui', 1);

        return Filter::apply('acf/advanced_link/fields', $builder);
    }
}
