<?php

namespace LeaseLeads\ThemeKit\Acf\Providers;

use LeaseLeads\ThemeKit\Acf\Services\Activator;
use LeaseLeads\ThemeKit\Acf\Services\ExtensionLoader;

use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use Leaseleads\ThemeKit\Core\Services\Filter;
use function LeaseLeads\ThemeKit\Core\Helpers\config;

class AcfProvider extends AbstractProvider implements ProviderInterface
{

    public function register(): void
    {
        $this->loadExtensions();
    }

    public function boot(): void
    {
        add_filter('plugins_loaded', [$this, 'configure']);

        Filter::register('plugins/required/acf', [$this, 'addAcfKey']);
        Filter::register('plugin/notice/fail/acf', function(string $message) {
            return 'Advanced Custom Fields failed to install and activate. Is the ACF_PRO_KEY set in the .env file?';
        });
    }

    public function addAcfKey($plugin): array
    {
        $activator = new Activator();

        if ($key = $activator->key()) {
            $plugin['uri'] .= '&k='.$key;
        }

        return $plugin;
    }

    public function configure(): void
    {
        $activator = new Activator();
        $activator->activate();
    }

    private function loadExtensions(): void
    {
        $loader = new ExtensionLoader();

        foreach(config('acf.extensions') as $extension) {
            $loader->registerExtension($extension);
        }

        $loader->loadExtensions();
    }
}
