<?php

namespace LeaseLeads\ThemeKit\Acf\Services;

use function LeaseLeads\ThemeKit\Core\Helpers\config;

class Activator {

    public function isInstalled(): bool
    {
        return file_exists(WP_PLUGIN_DIR . '/advanced-custom-fields-pro/acf.php');
    }

    public function key() : string|false {
        if ( defined('ACF_PRO_LICENSE') && is_string(ACF_PRO_LICENSE) ) {
            return ACF_PRO_LICENSE;
        }

        if ( $this->isActivated() ) {
            // Check if license is already activated
            $license = acf_pro_get_license();

            if ( ! empty($license['key']) ) {
                return $license['key'];
            }
        }

        return config('acf.key', false);
    }

    public function isActivated(): bool
    {
        if ( ! $this->isInstalled() ) {
            return false;
        }

        // Check for ACF_PRO_LICENSE
        if ( defined('ACF_PRO_LICENSE') ) {
            return true;
        }

        // Check if license is already activated
        $license = acf_pro_get_license();

        return ! empty($license['key']);
    }

    public function activate(): bool
    {
        if ( ! $this->isInstalled() ) {
            return false;
        }

        // Check wp-config.php for ACF_PRO_LICENSE
        if ( defined('ACF_PRO_LICENSE') ) {
            return true;
        }

        if ( ! function_exists('acf_pro_get_license')) {
            return false;
        }

        // Check if license is already activated
        if ( $this->isActivated() ) {
            return true;
        }

        if (! config('acf.key')) {
            return false;
        }

        // Activate license
        acf_pro_activate_license($_ENV['ACF_PRO_KEY']);
    }



}
