<?php

namespace LeaseLeads\ThemeKit\Acf\Services;

use LeaseLeads\ThemeKit\Acf\Contracts\Extension;

class ExtensionLoader {

    protected array $extensions = [];

    public function registerExtension(Extension $extension): void
    {
        $this->extensions[] = $extension;
    }

    public function loadExtensions(): void
    {
        collect($this->extensions)
            ->each(fn (Extension $extension) => add_action(
                'acf/init',
                fn() => $extension->load())
            );
    }


}
