<?php


namespace LeaseLeads\ThemeKit\Areas\Services;

use LeaseLeads\ThemeKit\Core\Services\Filter;
use function LeaseLeads\ThemeKit\Core\Helpers\buffered;

class Sidebars {

    public static function register(string $slug, string $name) : void {
        if ( ! did_action('widgets_init') ) {
            add_action('widgets_init', function() use ($slug, $name) {
                static::register($slug, $name);
            });

            return;
        }

        register_sidebar(static::configuration($name, $slug));
    }

    public static function configuration(string $title, ?string $slug) {
        $slug = $slug ?? sanitize_title($title);

        return Filter::apply('areas/sidebars/' . $slug . '/configuration', [
            'name' => $title,
            'id' => $slug,
            'before_widget' => '<div id="%1$s" class="widget widget-%2$s">',
            'after_widget' => '</div>',
            'before_title' => '<h3 class="widget-title">',
            'after_title' => '</h3>',
        ]);
    }

    public static function render(string $slug) : string {
        return buffered(fn() => Filter::apply(
            "areas/sidebars/{$slug}/render",
            is_active_sidebar($slug)
                ? dynamic_sidebar($slug)
                : '')
        );
    }

}
