<?php

namespace LeaseLeads\ThemeKit\Assets\Providers;

use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use Leaseleads\ThemeKit\Core\Services\Filter;
use Leaseleads\ThemeKit\Core\Services\Vite\Vite;
use function LeaseLeads\ThemeKit\Core\Helpers\config;
use function Leaseleads\ThemeKit\Core\Helpers\env;

class Assets extends AbstractProvider implements ProviderInterface {


    public function boot(): void
    {
        add_action('wp_enqueue_scripts', [$this, 'public'], 10);
        add_action('admin_enqueue_scripts', [$this, 'admin'], 10);
        add_action('login_enqueue_scripts', [$this, 'login'], 10);

        add_action('wp_enqueue_scripts', [$this, 'enqueue'], 50);
        add_action('admin_enqueue_scripts', [$this, 'enqueue'], 50);
        add_action('login_enqueue_scripts', [$this, 'enqueue'], 50);

        add_filter('style_loader_tag', [$this, 'layeredVendors'], 10, 4);
        add_action('after_setup_theme', [$this, 'registerImageSizes'], 10);

        add_action('wp_head', [$this, 'printThemeData'], 10);
    }


    public function public() : void {
        $vite = new Vite(config('assets.build'));
        $handle = $vite->enqueue(
            config('assets.entrypoints.public.resource'),
            config('assets.entrypoints.public.handle'));

        if ( ! env()->isFrontend() ) {
            return;
        }

        wp_enqueue_script($handle);

        add_action('wp_head', function() {
            $data = Filter::apply('theme/assets/data', []);

            print_r("<script nowprocket>window.LeaseLeads_Theme = " . json_encode($data) . "</script>");
        });
    }

    public function admin(): void
    {
        $vite = new Vite(config('assets.build'));
        $handle = $vite->enqueue(
            config('assets.entrypoints.admin.resource'),
            config('assets.entrypoints.admin.handle'));

        if ( ! env()->isAdmin() ) {
            return;
        }

        wp_enqueue_script($handle);

        add_action('admin_print_footer_scripts', function() {
            wp_script_modules()->print_import_map();
            wp_script_modules()->print_enqueued_script_modules();
            wp_script_modules()->print_script_module_preloads();
        });
    }

    public function login(): void
    {
        $vite = new Vite(config('assets.build'));
        $handle = $vite->enqueue(
            config('assets.entrypoints.login.resource'),
            config('assets.entrypoints.login.handle'));

        if ( ! env()->isLogin() ) {
            return;
        }

        wp_enqueue_script($handle);

        add_action('login_footer', function() {
            wp_script_modules()->print_import_map();
            wp_script_modules()->print_enqueued_script_modules();
            wp_script_modules()->print_script_module_preloads();
        });
    }

    public function layeredVendors($tag, $handle, $href, $media): string
    {
        if ( ! env()->isFrontend() ) {
            return $tag;
        }

        if ( str_contains($href, 'wp-content/themes') ) {
            return $tag;
        }

        if ( ! in_array($handle, config('assets.vendors')) ) {
            return $tag;
        }

        return implode("\n", [
            '<style id="' . $handle . '-css">',
            '@import url(' . $href . ') layer(vendor);',
            '</style>'
        ]);
    }

    public function registerImageSizes(): void
    {
        $sizes = config('assets.images.sizes');

        foreach ($sizes as $name => $config) {

            $config = wp_parse_args(
                $config,
                [
                    'width' => 0,
                    'height' => 0,
                    'crop' => true,
                ]
            );

            if ( $config['height'] === 0 ) {
                $crop = false;
            }

            add_image_size($name, $config['width'] ?? 0, $config['height'] ?? 0, $crop);
        }
    }

    public function printThemeData(): void
    {
        $data = Filter::apply('assets/data', []);

        echo implode("\n", [
            "\n<script data-nowprocket>",
            "\n\twindow.LeaseLeads_Theme = " . json_encode($data),
            "\n</script>\n"
        ]);
    }

}
