<?php


namespace Leaseleads\ThemeKit\Core\Services\Vite;

class Adapter {

    protected Manifest $manifest;

    public function __construct(Manifest $manifest) {
        $this->manifest = $manifest;
    }

    public function dependencies(string $resource) : array {
        return $this->processDependencies($resource);
    }

    public function __call($method, $args) {
        return $this->manifest->$method(...$args);
    }

    protected function dependency(string $resource): array
    {
        $record = $this->manifest->record($resource);
        $file = $record['file'];

        return [
            'resource' => $resource,
            'id' => sanitize_title($resource),
            'file' => $file,
            'import' => 'static'
        ];
    }

    protected function processDependencies(string $resource, array $deps = []) : array {
        $record = $this->manifest->record($resource);


        $deps[] = $this->dependency($resource);

        if ( isset($record['imports']) ) {
            $deps = array_merge($deps, $this->processDependencyTree($record['imports'], $deps));
        }

        return $deps;
    }

    protected function processDependencyTree(array $imports, array $deps = []): array
    {
        foreach( $imports as $dependency) {
            if ( ! str_starts_with($dependency, 'resources') ) {
                continue;
            }

            $is_registered = in_array($dependency, array_column($deps, 'resource'));

            if ( ! $is_registered ) {
                $deps = array_merge($deps, $this->processDependencies($dependency, $deps));
            }
        }

        return $deps;
    }

}
