<?php

namespace Leaseleads\ThemeKit\Core\Services\Vite;


class Asset {

    protected Server $server;

    protected Manifest $manifest;

    protected Adapter $adapter;

    public function __construct(Server $server, Manifest $manifest, Adapter $adapter) {
        $this->server = $server;
        $this->manifest = $manifest;
        $this->adapter = $adapter;
    }

    public function enqueue(string $resource, ?string $handle = null): string
    {
        $handle = $this->enqueueScript($resource, $handle);

        if ( ! $this->server->hot() ) {
            $this->enqueueStyle($resource);
        }

        return $handle;
    }


    private function enqueueScript(string $resource, ?string $handle = null): string
    {
        $record = $this->manifest->record($resource);
        $handle = $handle ?? 'leaseleads-theme-' . ($record['name'] ?? $resource);
        $url = $this->server->endpoint($record);

        $dependencies = $this->adapter->dependencies($resource);
        $dependencies[] = [
            'id' => 'jquery',
            'import' => 'static'
        ];

        foreach($dependencies as $dependency) {
            if ( ! array_key_exists('file', $dependency ) ) {
                continue;
            }

            wp_register_script_module($dependency['id'], $this->server->endpoint($this->manifest->record($dependency['resource'])), [], wp_get_theme()->get('Version'));
        }

        wp_enqueue_script_module($handle, $url, $dependencies, wp_get_theme()->get('Version'));
        return $handle;
    }

    private function enqueueStyle(string $resource) {
        $record = $this->manifest->record($resource);

        if ( ! array_key_exists('css', $record) ) {
            return;
        }

        foreach( $record['css'] as $style ) {
            $url = $this->server->endpoint($style);
            wp_enqueue_style('leaseleads-theme-' . $style, $url, [], wp_get_theme()->get('Version'));
        }
    }

}
