<?php

return [

    /**
     * The folder where the assets are built to relative to the theme root.
     */
    'build' => 'public',

    /**
     * The folder where the original assets are stored relative to the theme root.
     */
    'source' => 'resources',

    /**
     * The entrypoints for the theme assets.
     * @var {string} 'resource' This should correspond to a key in your manifest.json file.
     * @var {string} 'handle' The handle to use when enqueuing the script.
     */
    'entrypoints' => [


        /**
         * Loaded on the frontend of the site.
         */
        'public' => [
            'handle' => 'leaseleads-theme-script-public',
            'resource' => 'resources/public/public.js',
        ],


        /**
         * Loaded in the admin area of the site.
         */
        'admin' => [
            'handle' => 'leaseleads-theme-script-admin',
            'resource' => 'resources/admin/admin.js',
        ],


        /**
         * Loaded on the login page.
         */
        'login' => [
            'handle' => 'leaseleads-theme-script-login',
            'resource' => 'resources/login/login.js',
        ],
    ],

    'images' => [

        /**
         * The additional sizes to generate for each image.
         * A 0 (zero) value for the height will result in no cropping
         */
        'sizes' => [
            'xxsmall' => [
                'width' => 375,
                'height' => 0,
            ],
            'xsmall' => [
                'width' => 640,
                'height' => 0,
            ],
            'small' => [
                'width' => 1024,
                'height' => 0,
            ],

            /**
             * Medium and Large are set within the admin under Settings > Media
             * Suggested values are provided here for reference.
             */
            // 'medium' => [
            //   'width' => 1280,
            //   'height' => 0,
            // ],
            // 'large' => [
            //   'width' => 1440,
            //   'height' => 0,
            // ],

            'xlarge' => [
                'width' => 1520,
                'height' => 0,
            ],
            'xxlarge' => [
                'width' => 1920,
                'height' => 0,
            ],
        ],

        'quality' => 100,
    ],

    /**
     * For third-party styles you want to be placed in a CSS layer for easier styling, add their handles
     * here, and they will be use @import in a style tag with the layer(vendor) directive.
     *
     * @var {array} 'vendors' The handles of the styles you want to wrap in a CSS "vendor" layer.
     */
    'vendors' => [
        'gravity_forms_theme_reset',
        'gravity_forms_theme_foundation',
        'gravity_forms_theme_framework',
        'gravity_forms_orbital_theme',
    ]
];
