<?php

namespace LeaseLeads\ThemeKit;

use LeaseLeads\ThemeKit\Core\Helpers\config;

class Bootloader
{

    /**
     * Bootstrap the application services.
     */
    public function boot(): void
    {
        foreach(Config('app.providers', []) as $provider) {
            if (class_exists($provider)) {
                $instance = new $provider();
                if (method_exists($instance, 'register')) {
                    $instance->register();
                }
                if (method_exists($instance, 'boot')) {
                    $instance->boot();
                }
            } else {
                error_log("Provider class {$provider} does not exist.");
            }
        }
    }
}
