<?php

namespace LeaseLeads\ThemeKit\Core\Commands;


use LeaseLeads\ThemeKit\Core\Contracts\CommandInterface;
use function LeaseLeads\ThemeKit\Core\Helpers\config;

class PublishConfigs implements CommandInterface {

    protected $args = [];

    public function name(): string
    {
        return 'config:publish';
    }

    public function description(): string
    {
        return 'Publish configuration files from theme packages to the `configs` directory.';
    }

    public function run(): void
    {
        config('app.providers')
            ->filter(fn($provider) => method_exists($provider, 'publishConfiguration'))
            ->each(function ($provider) {
                $provider->publishConfiguration($this->args['force'] ?? false);
            });
    }

    public function arguments(): array
    {
        return [
            'force' => [
                'description' => 'Force publish configuration files, overwriting existing ones.',
                'default' => false,
                'type' => 'boolean',
                'optional' => true
            ]
        ];
    }
}
