<?php

namespace LeaseLeads\ThemeKit\Core\Helpers;

use Leaseleads\ThemeKit\Core\Services\Config;
use Leaseleads\ThemeKit\Core\Services\Environment;

function config(?string $key = null, $default = null) : mixed {
    if (is_null($key)) {
        return Config::all();
    }

    return Config::get($key, $default);
}

function env(?string $key = null) : mixed {
    if (is_null($key)) {
        return new Environment();
    }

    return (new Environment())->get($key);
}

function bound_by(string $class, string $interface): bool {
    if (class_exists($class)) {
        return in_array($interface, class_implements($class), true);
    }

    return false;
}

function buffered(callable $callback): string {
    ob_start();
    $callback();
    return ob_get_clean();
}

function remember_transient(string $key, callable $value) : mixed {
    $key = "leaseleads/theme/transient/{$key}";

    if ( get_transient($key) !== false ) {
        return get_transient($key);
    }

    set_transient($key, $value());

    return $value;
}

function forget_transient(string $key): void {
    $key = "leaseleads/theme/transient/{$key}";
    delete_transient($key);
}
