<?php

namespace LeaseLeads\ThemeKit\Core\Providers;

use Leaseleads\ThemeKit\Core\Services\ThemeCommand;
use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use function LeaseLeads\ThemeKit\Core\Helpers\config;

class Commands extends AbstractProvider implements ProviderInterface {

    protected ThemeCommand $commander;

    public function __construct() {
        $this->commander = new ThemeCommand();
    }

    public function register(): void
    {
        if ( ! defined('WP_CLI') || ! WP_CLI ) {
            return;
        }

        $commands = config('app.commands');

        foreach ($commands as $command) {
            $command = new $command;
            $name = $command->name();

            $this->commander->register_sub_command($name, $command->description(), function() use ($command) {
                $command->run();
            });
        }
    }

    public function boot(): void
    {
        \WP_CLI::add_command($this->commander->name(), function(...$args) {
            $this->commander->run(...$args);
        });
    }

}
