<?php

namespace LeaseLeads\ThemeKit\Core\Services;

use Illuminate\Support\Arr;

class Config {
    /**
     * Get the value of a configuration item using dot notation.
     *
     * @param string $key
     * @param mixed $default
     * @return mixed
     */
    public static function get(string $key, $default = null)
    {
        $accessor = explode('.', $key);
        $file = array_pop($accessor);

        $defaults = include '../config/' . $file . '.php';
        $config = include get_template_directory() . '/config/' . $file . '.php';

        $config = self::merge($defaults, is_array($config) ? $config : []);

        $value = Filter::apply("config/$file", Arr::get($config, implode('.', $accessor), $default));
        return Filter::apply("config/$file/" . str_replace('.', '/', implode('.', $accessor)), $value);
    }

    /**
     * Get all configuration items.
     *
     * @return array
     */
    public static function all(): array
    {
        $config = [];
        $files = glob(get_template_directory() . '/config/*.php');

        foreach ($files as $file) {
            $fileName = basename($file, '.php');
            $config[$fileName] = self::get($fileName, []);
        }

        return Filter::apply('config', $config);
    }

    public static function merge($defaults, $config) {
        if (is_array($config)) {
            return array_merge_recursive($defaults, $config);
        }

        return $defaults;
    }
}
