<?php

namespace LeaseLeads\ThemeKit\Deploy\Commands;

use LeaseLeads\ThemeKit\Core\Services\Filter;
use function LeaseLeads\ThemeKit\Core\Helpers\env;
use function LeaseLeads\ThemeKit\Core\Helpers\config;

class Zip extends BaseCommand {

    public function name(): string
    {
        return 'zip';
    }

    public function description(): string
    {
        return 'Packages the theme for release.';
    }

    public function run(): void
    {

        $themePath = get_template_directory();
        $themeDir = basename($themePath);
        $composerJsonPath = $themePath . '/composer.json';

        $exclusions = Filter::apply(
            'deploy/commands/zip/exclusions',
            array_map(fn($path) => "$themeDir/$path", config('deploy.exclusions', [])));

        $exclusions = array_map(fn($path) => escapeshellarg($path), $exclusions);

        if ( ! env()->isLocal() ) {
            \WP_CLI::error('This command is intended for development environments only.');
            return;
        }

        $commands = [
            [
                'command' => "composer install --no-dev --optimize-autoloader",
                'executor' => fn($cmd) => exec($cmd." &> /dev/null"),
                'message' => 'Installing composer dependencies',
            ],
            [
                'command' => "pnpm install; pnpm run production",
                'executor' => fn($cmd) => exec($cmd." &> /dev/null"),
                'message' => 'Compiling assets',
            ],
            [
                'command' => "cd {$this->localContent('themes')}; rm -f {$this->localContent("themes/$themeDir.zip")}; zip -r {$themeDir}.zip ./{$themeDir} -x " . implode(" ", $excludes),
                'executor' => fn($cmd) => exec($cmd),
                'message' => 'Zipping theme',
            ],
            [
                'command' => "$themePath/{$themeDir}.zip",
                'executor' => fn($cmd) => file_exists($cmd) ? unlink($cmd) : '',
                'message' => 'Removing old zip file',
            ],
        ];

        if (!file_exists($composerJsonPath)) {
            \WP_CLI::error('composer.json not found. Exiting...');
            return;
        }

        foreach($commands as $command) {
            $command['command'] = "cd $themePath; " . $command['command'];
            $this->runCommand(...$command);
        }

        \WP_CLI::success('Theme packaged successfully.');

    }
}
