<?php

namespace LeaseLeads\ThemeKit\Plugins\Services;


use LeaseLeads\ThemeKit\Core\Services\Filter;
use LeaseLeads\ThemeKit\Plugins\Contracts\InstallerInterface;
use WP_Dependency_Installer;

class WpDependencyInstaller implements InstallerInterface {

    protected array $configuration;
    protected WP_Dependency_Installer $installer;

    public function __construct(array $configuration) {
        $this->configuration = $configuration;
        $this->installer = WP_Dependency_Installer::instance(get_template_directory());
    }

    public function install(): void
    {
        $slug = basename($this->configuration['slug'], '.php');
        $this->configuration = Filter::apply("plugins/$slug/configuration", $this->configuration);

        $this->installer->register([$this->configuration]);
    }

    public function activate(): void
    {
        $this->installer->activate($this->configuration['slug']);
    }

    public function isInstalled() : bool
    {
        return $this->installer->is_installed($this->configuration['slug']);
    }

    public function isActivated() : bool
    {
        return $this->installer->is_active($this->configuration['slug']);
    }
}
