<?php

namespace LeaseLeads\ThemeKit\Settings\Sections;

use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\Builder;
use function LeaseLeads\ThemeKit\Core\Helpers\forget_transient;
use function LeaseLeads\ThemeKit\Core\Helpers\remember_transient;

abstract class AbstractSection implements SectionInterface {

    public string $transientKey;

    public function __construct() {
        $this->transientKey = "settings/{$this->page()}/section/{$this->name()}";
        add_action('acf/options_page/save', [$this, 'reset'], 10, 2);
    }

    public function reset($post_id, $menu_slug): void {
        forget_transient($this->transientKey);
        $this->values();
    }

    public function values() : array {
        return remember_transient(
            $this->transientKey,
            fn() => get_fields('options')[$this->page()][$this->name()] ?? []);
    }

    public function name(): string
    {
        return str_replace('-', '_', sanitize_key($this->title()));
    }

    abstract public function page() : string;

    abstract public function fields(Builder $builder): void;

    abstract public function title(): string;

}
