<?php

namespace LeaseLeads\ThemeKit\Settings\Services;

use Illuminate\Support\Facades\Validator;
use LeaseLeads\ThemeKit\Core\Services\Filter;
use LeaseLeads\ThemeKit\Settings\Contracts\SectionInterface;
use StoutLogic\AcfBuilder\FieldsBuilder;

class SettingsPage {

    protected array $page = [];
    protected array $sections = [];

    public function __construct(array $page) {

        $this->page = Validator::validate($page, [
            'slug' => 'string',
            'title' => 'string',
            'parent' => 'nullable|string',
        ]);
    }

    public function configuration() : array {

        return Filter::apply("settings/page/{$this->page['slug']}/configuration", array_filter([
            'page_title' => $this->page['title'],
            'menu_title' => $this->page['title'],
            'menu_slug' => $this->page['slug'],
            'capability' => 'edit_others_posts',
            'redirect' => false,
            'parent_slug' => $this->page['parent'] ?? null,
        ], function($value) {

            return ! is_null($value);
        }));
    }

    public function registerSection(SectionInterface $section): void
    {
        $this->sections[] = $section;
    }

    public function build() : void {

        $config = $this->configuration();

        $builder = (new FieldsBuilder($this->page['slug']))
            ->setLocation('options_page', '==', $this->page['slug']);

        foreach ($this->sections as $section) {

                $group = $builder
                    ->addTab($section->title(), ['placement' => 'left'])
                    ->addGroup($section->name(), [
                        'label' => $section->title()
                    ]);

                $section->fields($group);

                $group->endGroup();
        }

        if (isset($config['parent_slug'])) {

            acf_add_options_sub_page($config);
        } else {

            acf_add_options_page($config);
        }

        $builder = Filter::apply('settings/page/' . $this->page['slug'] . '/fields', $builder);
        acf_add_local_field_group($builder->build());
    }

}
