<?php

use Leaseleads\ThemeKit\Core\Providers\Update;

return [

    'name' => wp_get_theme()->get('Name'),

    'updates' => [
        'url' => sprintf("https://templates.leaseleads.co/updates/%s/info.php", basename(get_template_directory()))
    ],


    'providers' => [
        Update::class,

    ],

    /**
     * Determine whether or not to disable gutenberg.
     *
     * false :  Will remove the gutenberg block editor on post edit screens and
     *          widget screen.
     *
     * false :  Will keep the gutenberg block editor.
     */
    'gutenberg' => false,

    /**
     * Determine whether to load jQuery from a CDN when viewing the frontend. Accepts a boolean or a version number.
     *
     * false :  Will continue to load jQuery from WordPress core, along with the jQuery migrate script.
     *
     * string : Will load the specified version of jQuery from a CDN. If a string is not provided, the 3.6.0 version
     *          will be loaded.
     *
     * @note    "latest" is not a valid version number. See jQuery notes regarding why:
     * @see     https://blog.jquery.com/2014/07/03/dont-use-jquery-latest-js/
     */
    'jquery' => '3.7.1',

    'commands' => [],

    'supports' => [
        'menus',
        'post-thumbnails',
        'title-tag',
        'html5' => [
            'comment-list',
            'comment-form',
            'search-form',
            'gallery',
            'caption'
        ],
        'customize-selective-refresh-widgets',
        'responsive-embeds',
        'editor-styles',
        'editor-color-palette'
    ]
];
