<?php

namespace LeaseLeads\ThemeKit\Acf\Extensions;

use LeaseLeads\ThemeKit\Acf\Contracts\ExtensionInterface;
use StoutLogic\AcfBuilder\FieldsBuilder;

class MenuLinkFields implements ExtensionInterface {


    public function load(): void
    {
        add_action('acf/init', function() {
            $builder = new FieldsBuilder('menu_item_icons');
            $message = sprintf('Add a <a href="https://fontawesome.com/icons">Font Awesome icon html code</a>.<br>
            Example: <code>%s</code>', htmlentities('<i class="fa-sharp fa-comment-lines"></i>'));

            $builder
                ->addText('icon', ['label' => 'Icon'])
                ->setInstructions($message)
                ->setLocation('nav_menu_item', '==', 'all');

            acf_add_local_field_group($builder->build());
        });
    }
}
