<?php

namespace LeaseLeads\ThemeKit\Acf\Extensions;



use LeaseLeads\ThemeKit\Acf\Contracts\ExtensionInterface;

class VeryBasicWysiwyg implements ExtensionInterface {

    public function load(): void
    {
        add_filter( 'acf/fields/wysiwyg/toolbars' , [$this, 'toolbarConfig'] );
    }

    public function toolbarConfig( $toolbars ) {
        // Add a new "Very Basic" toolbar
        $toolbars['Very Basic'] = [
            0 => [],
            1 => [
                'bold',
                'italic',
                'underline',
                'strikethrough',
                'bullist',
                'numlist',
                'link',
                'unlink',
            ]
        ];

        return $toolbars;
    }
}
