<?php

namespace LeaseLeads\ThemeKit\Acf\Providers;

use LeaseLeads\ThemeKit\Acf\Contracts\ExtensionInterface;
use LeaseLeads\ThemeKit\Acf\Services\Activator;
use LeaseLeads\ThemeKit\Acf\Services\ExtensionLoader;

use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Core\Services\Filter;
use function LeaseLeads\ThemeKit\bound_by;
use function LeaseLeads\ThemeKit\config;

class AcfProvider extends AbstractProvider implements ProviderInterface
{

    public function setup(): void
    {
        add_filter('wp_dependency_download_link', [$this, 'addAcfKey'], 10, 2);
    }

    public function register(): void
    {
        $this->loadExtensions();
    }

    public function boot(): void
    {
        add_filter('plugins_loaded', [$this, 'configure'], 20);

        Filter::register('plugin/notice/fail/acf', function(string $message) {
            return 'Advanced Custom Fields failed to install and activate. Is the ACF_PRO_KEY set in the .env file?';
        });
    }

    public function addAcfKey($link, $plugin): string
    {
        if ( $plugin['slug'] !== 'advanced-custom-fields-pro/acf.php' ) {
            return $link;
        }

        $activator = new Activator();

        if ($key = $activator->key()) {
            $link .= '&k='.$key;
        }

        return $link;
    }

    public function configure(): void
    {
        $activator = new Activator();
        $activator->activate();
    }

    private function loadExtensions(): void
    {
        $loader = new ExtensionLoader();

        foreach(config('acf.extensions') as $extension) {
            if ( ! bound_by($extension, ExtensionInterface::class) ) {
                throw new \InvalidArgumentException(sprintf(
                    'Extension %s must implement ' . ExtensionInterface::class,
                    $extension
                ));
            }

            $loader->registerExtension(new $extension());
        }

        $loader->loadExtensions();
    }
}
