<?php

namespace LeaseLeads\ThemeKit\Areas\Providers;

use Illuminate\Support\Collection;
use LeaseLeads\ThemeKit\Areas\Services\Sidebars;
use LeaseLeads\ThemeKit\Core\Contracts\FieldableInterface;
use LeaseLeads\ThemeKit\Core\Contracts\ProviderInterface;
use LeaseLeads\ThemeKit\Core\Providers\AbstractProvider;
use LeaseLeads\ThemeKit\Core\Services\Filter;
use function LeaseLeads\ThemeKit\config;

class Sidebar extends AbstractProvider implements ProviderInterface
{
    protected Collection $sidebars;
    protected Collection $widgets;

    public function register(): void
    {
        $this->sidebars = collect(config('areas.sidebars', []))
            ->map(fn ($title, $slug) => Sidebars::register($slug, $title));

        $this->widgets = collect(config('areas.widgets', []));
    }

    public function boot(): void
    {
        add_action('widgets_init', [$this, 'registerSidebars']);
        add_action('widgets_init', [$this, 'registerWidgets']);
        add_action('acf/init', [$this, 'registerWidgetFields']);
        add_action('after_setup_theme', fn() => register_nav_menus(config('areas.menus')));
    }

    public function registerWidgets(): void
    {
        foreach (config('areas.widgets') as $widget) {
            register_widget($widget);
        }
    }

    public function registerWidgetFields(): void
    {
        foreach(config('areas.widgets') as $widget) {

            if ( ! class_exists($widget) ) {
                continue;
            }

            if ( ! bound_by($widget, FieldableInterface::class) ) {
                continue;
            }

            $widget = new $widget();
            $fields = $widget->fields();

            $fields
                ->setLocation('widget', '==', $widget->id());

            $fields = Filter::apply('widget/fields', $fields);
            $fields = Filter::apply('widget/fields/' . $widget->id(), $fields);

            acf_add_local_field_group($fields->build());
        }
    }

    public function registerMenus(): void
    {
        register_nav_menus(config('areas.menus'));
    }
}
