<?php

namespace LeaseLeads\ThemeKit\Core\Services\Vite;

class Server {

    protected string $buildFolder;

    protected string $hotPath;

    public function __construct(string $buildFolder) {
        $this->buildFolder = $buildFolder;
        $this->hotPath = implode('/', [get_template_directory(), $this->buildFolder, 'hot']);
    }

    public function url() {
        return $this->hot()
            ? file_get_contents($this->hotPath)
            : get_template_directory_uri() . '/' . $this->buildFolder;
    }

    public function hot() {
        return file_exists($this->hotPath);
    }

    public function endpoint(string|array $record) : string {
        if ( is_array($record) ) {
            $record = $this->hot()
                ? ($record['src'] ?? $record['file'])
                : $record['file'];
        }

        return implode('/', [$this->url(), $record]);
    }

}
