<?php

namespace LeaseLeads\ThemeKit;

use function LeaseLeads\ThemeKit\config;

class Bootloader
{

    /**
     * Bootstrap the application services.
     */
    public function boot(): void
    {
        require_once(__DIR__ . '/functions.php');

        $instances = [];

        foreach(\LeaseLeads\ThemeKit\config('app.providers', []) as $provider) {
            if (class_exists($provider)) {
                $instance = new $provider();
                $instances[] = $instance;

                if (method_exists($provider, 'setup')) {
                    $instance->setup();
                }
            }
        }

        add_action('after_setup_theme', function() use ($instances) {
            foreach ($instances as $instance) {
                if (method_exists($instance, 'register')) {
                    $instance->register();
                }
            }

            foreach ($instances as $instance) {
                if (method_exists($instance, 'boot')) {
                    $instance->boot();
                }
            }
        });
    }
}
